/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "${hspeakers}", "click", function(sym, e) {
         // insert code for mouse click here
         // Show an element 
         sym.$("gspeakers").fadeIn();
         sym.$("gspeakers").delay(4000).fadeOut(1000);
         
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("speakerssound")[0].currentTime = 0;
         if (sym.$("speakerssound")[0].paused) {
         	sym.$("speakerssound")[0].play();
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${close2}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("gspeakers").hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${speakers}", "click", function(sym, e) {
         
         // Play an audio track 
         sym.$("speakerssound")[0].play();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${closeprinter}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("gprinter").hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${hprinter}", "click", function(sym, e) {
         // insert code for mouse click here
         
         sym.$("gprinter").fadeIn();
         sym.$("gprinter").delay(4000).fadeOut(1000);
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("printersound")[0].currentTime = 0;
         if (sym.$("printersound")[0].paused) {
         	sym.$("printersound")[0].play();
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${closegmonitor}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("gmonitor").hide();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${hmonitor}", "click", function(sym, e) {
         // insert code for mouse click here
         
         sym.$("gmonitor").fadeIn();
         sym.$("gmonitor").delay(4000).fadeOut(1000);
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("monitorsound")[0].currentTime = 0;
         if (sym.$("monitorsound")[0].paused) {
         	sym.$("monitorsound")[0].play();
         }
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${closegkeyboard}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("gkeyboard").hide();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${hkeyboard}", "click", function(sym, e) {
         // insert code for mouse click here
         
         sym.$("gkeyboard").fadeIn();
         sym.$("gkeyboard").delay(4000).fadeOut(1000);
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("keyboardsound")[0].currentTime = 0;
         if (sym.$("keyboardsound")[0].paused) {
         	sym.$("keyboardsound")[0].play();
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${hmouse}", "click", function(sym, e) {
         // insert code for mouse click here
         
         sym.$("gmouse").fadeIn();
         sym.$("gmouse").delay(4000).fadeOut(1000);
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("mousesound")[0].currentTime = 0;
         if (sym.$("mousesound")[0].paused) {
         	sym.$("mousesound")[0].play();
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${closegmouse}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("gmouse").hide();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${closegsystem}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("gsystem").hide();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${hsystem}", "click", function(sym, e) {
         // insert code for mouse click here
         // insert code for mouse click here
         
         sym.$("gsystem").fadeIn();
         sym.$("gsystem").delay(4000).fadeOut(1000);
         
         
         // Replay an audio track from the beginning, regardless of current playing state 
         sym.$("systemsound")[0].currentTime = 0;
         if (sym.$("systemsound")[0].paused) {
         	sym.$("systemsound")[0].play();
         }

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${audio}", "click", function(sym, e) {
         // insert code for mouse click here
         // Play an audio track 
         sym.$("tap_on_the_hotspot")[0].play();
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "EDGE-526075");